package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamAccessKeySessionContext(
    attributes: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes
    ] = Optional.Absent,
    sessionIssuer: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContext = {
    import AwsIamAccessKeySessionContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContext
      .builder()
      .optionallyWith(attributes.map(value => value.buildAwsValue()))(
        _.attributes
      )
      .optionallyWith(sessionIssuer.map(value => value.buildAwsValue()))(
        _.sessionIssuer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly =
    zio.aws.securityhub.model.AwsIamAccessKeySessionContext
      .wrap(buildAwsValue())
}
object AwsIamAccessKeySessionContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamAccessKeySessionContext =
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext(
        attributes.map(value => value.asEditable),
        sessionIssuer.map(value => value.asEditable)
      )
    def attributes: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes.ReadOnly
    ]
    def sessionIssuer: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly
    ]
    def getAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("attributes", attributes)
    def getSessionIssuer: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly
    ] = AwsError.unwrapOptionField("sessionIssuer", sessionIssuer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContext
  ) extends zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly {
    override val attributes: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        zio.aws.securityhub.model.AwsIamAccessKeySessionContextAttributes
          .wrap(value)
      )
    override val sessionIssuer: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionIssuer())
      .map(value =>
        zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContext
  ): zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly =
    new Wrapper(impl)
}
