package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerHealthCheck(
    healthyThreshold: Optional[Integer] = Optional.Absent,
    interval: Optional[Integer] = Optional.Absent,
    target: Optional[NonEmptyString] = Optional.Absent,
    timeout: Optional[Integer] = Optional.Absent,
    unhealthyThreshold: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck = {
    import AwsElbLoadBalancerHealthCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
      .builder()
      .optionallyWith(healthyThreshold.map(value => value: java.lang.Integer))(
        _.healthyThreshold
      )
      .optionallyWith(interval.map(value => value: java.lang.Integer))(
        _.interval
      )
      .optionallyWith(
        target.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.target)
      .optionallyWith(timeout.map(value => value: java.lang.Integer))(_.timeout)
      .optionallyWith(
        unhealthyThreshold.map(value => value: java.lang.Integer)
      )(_.unhealthyThreshold)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerHealthCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck =
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck(
        healthyThreshold.map(value => value),
        interval.map(value => value),
        target.map(value => value),
        timeout.map(value => value),
        unhealthyThreshold.map(value => value)
      )
    def healthyThreshold: Optional[Integer]
    def interval: Optional[Integer]
    def target: Optional[NonEmptyString]
    def timeout: Optional[Integer]
    def unhealthyThreshold: Optional[Integer]
    def getHealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("healthyThreshold", healthyThreshold)
    def getInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("interval", interval)
    def getTarget: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("target", target)
    def getTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getUnhealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly {
    override val healthyThreshold: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.healthyThreshold())
      .map(value => value: Integer)
    override val interval: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => value: Integer)
    override val target: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => value: Integer)
    override val unhealthyThreshold: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.unhealthyThreshold())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
  ): zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly =
    new Wrapper(impl)
}
