package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails = {
    import AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(
          name.map(value => value),
          value.map(value => value)
        )
    def name: Optional[NonEmptyString]
    def value: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.ReadOnly =
    new Wrapper(impl)
}
