package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceServiceRegistriesDetails(
    containerName: Optional[NonEmptyString] = Optional.Absent,
    containerPort: Optional[Integer] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    registryArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails = {
    import AwsEcsServiceServiceRegistriesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
      .builder()
      .optionallyWith(
        containerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .optionallyWith(containerPort.map(value => value: java.lang.Integer))(
        _.containerPort
      )
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        registryArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.registryArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceServiceRegistriesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails =
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails(
        containerName.map(value => value),
        containerPort.map(value => value),
        port.map(value => value),
        registryArn.map(value => value)
      )
    def containerName: Optional[NonEmptyString]
    def containerPort: Optional[Integer]
    def port: Optional[Integer]
    def registryArn: Optional[NonEmptyString]
    def getContainerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getRegistryArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("registryArn", registryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly {
    override val containerName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val containerPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: Integer)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val registryArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.registryArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
  ): zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly =
    new Wrapper(impl)
}
