package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsClusterConfigurationDetails(
    executeCommandConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationDetails = {
    import AwsEcsClusterConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationDetails
      .builder()
      .optionallyWith(
        executeCommandConfiguration.map(value => value.buildAwsValue())
      )(_.executeCommandConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsClusterConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails =
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails(
        executeCommandConfiguration.map(value => value.asEditable)
      )
    def executeCommandConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly
    ]
    def getExecuteCommandConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executeCommandConfiguration",
      executeCommandConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly {
    override val executeCommandConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.executeCommandConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
