package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VolumeDetails(
    createTime: Optional[NonEmptyString] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    size: Optional[Integer] = Optional.Absent,
    snapshotId: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    attachments: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2VolumeAttachment]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails = {
    import AwsEc2VolumeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
      .builder()
      .optionallyWith(
        createTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createTime)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(
        snapshotId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VolumeDetails.wrap(buildAwsValue())
}
object AwsEc2VolumeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VolumeDetails =
      zio.aws.securityhub.model.AwsEc2VolumeDetails(
        createTime.map(value => value),
        encrypted.map(value => value),
        size.map(value => value),
        snapshotId.map(value => value),
        status.map(value => value),
        kmsKeyId.map(value => value),
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def createTime: Optional[NonEmptyString]
    def encrypted: Optional[Boolean]
    def size: Optional[Integer]
    def snapshotId: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def kmsKeyId: Optional[NonEmptyString]
    def attachments: Optional[
      List[zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly]
    ]
    def getCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
  ) extends zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly {
    override val createTime: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val size: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Integer)
    override val snapshotId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val attachments: Optional[
      List[zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2VolumeAttachment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
  ): zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly = new Wrapper(impl)
}
