package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VolumeAttachment(
    attachTime: Optional[NonEmptyString] = Optional.Absent,
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    instanceId: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment = {
    import AwsEc2VolumeAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
      .builder()
      .optionallyWith(
        attachTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.attachTime)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VolumeAttachment.wrap(buildAwsValue())
}
object AwsEc2VolumeAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VolumeAttachment =
      zio.aws.securityhub.model.AwsEc2VolumeAttachment(
        attachTime.map(value => value),
        deleteOnTermination.map(value => value),
        instanceId.map(value => value),
        status.map(value => value)
      )
    def attachTime: Optional[NonEmptyString]
    def deleteOnTermination: Optional[Boolean]
    def instanceId: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def getAttachTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
  ) extends zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly {
    override val attachTime: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.attachTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val instanceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
  ): zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly = new Wrapper(
    impl
  )
}
