package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginGroup(
    failoverCriteria: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup = {
    import AwsCloudFrontDistributionOriginGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
      .builder()
      .optionallyWith(failoverCriteria.map(value => value.buildAwsValue()))(
        _.failoverCriteria
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup(
        failoverCriteria.map(value => value.asEditable)
      )
    def failoverCriteria: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly
    ]
    def getFailoverCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly
    ] = AwsError.unwrapOptionField("failoverCriteria", failoverCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly {
    override val failoverCriteria: Optional[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failoverCriteria())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly =
    new Wrapper(impl)
}
