package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateDomainValidationOption(
    domainName: Optional[NonEmptyString] = Optional.Absent,
    resourceRecord: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord
    ] = Optional.Absent,
    validationDomain: Optional[NonEmptyString] = Optional.Absent,
    validationEmails: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    validationMethod: Optional[NonEmptyString] = Optional.Absent,
    validationStatus: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption = {
    import AwsCertificateManagerCertificateDomainValidationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
      .builder()
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(resourceRecord.map(value => value.buildAwsValue()))(
        _.resourceRecord
      )
      .optionallyWith(
        validationDomain.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.validationDomain)
      .optionallyWith(
        validationEmails.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validationEmails)
      .optionallyWith(
        validationMethod.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.validationMethod)
      .optionallyWith(
        validationStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.validationStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateDomainValidationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption =
      zio.aws.securityhub.model
        .AwsCertificateManagerCertificateDomainValidationOption(
          domainName.map(value => value),
          resourceRecord.map(value => value.asEditable),
          validationDomain.map(value => value),
          validationEmails.map(value => value),
          validationMethod.map(value => value),
          validationStatus.map(value => value)
        )
    def domainName: Optional[NonEmptyString]
    def resourceRecord: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly
    ]
    def validationDomain: Optional[NonEmptyString]
    def validationEmails: Optional[List[NonEmptyString]]
    def validationMethod: Optional[NonEmptyString]
    def validationStatus: Optional[NonEmptyString]
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getResourceRecord: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly
    ] = AwsError.unwrapOptionField("resourceRecord", resourceRecord)
    def getValidationDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("validationDomain", validationDomain)
    def getValidationEmails: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("validationEmails", validationEmails)
    def getValidationMethod: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("validationMethod", validationMethod)
    def getValidationStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("validationStatus", validationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly {
    override val domainName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourceRecord: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRecord())
      .map(value =>
        zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord
          .wrap(value)
      )
    override val validationDomain: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationDomain())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val validationEmails: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationEmails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val validationMethod: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationMethod())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val validationStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly =
    new Wrapper(impl)
}
