package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingLaunchConfigurationDetails(
    associatePublicIpAddress: Optional[Boolean] = Optional.Absent,
    blockDeviceMappings: Optional[Iterable[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
    ]] = Optional.Absent,
    classicLinkVpcId: Optional[NonEmptyString] = Optional.Absent,
    classicLinkVpcSecurityGroups: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    createdTime: Optional[NonEmptyString] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    iamInstanceProfile: Optional[NonEmptyString] = Optional.Absent,
    imageId: Optional[NonEmptyString] = Optional.Absent,
    instanceMonitoring: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
    ] = Optional.Absent,
    instanceType: Optional[NonEmptyString] = Optional.Absent,
    kernelId: Optional[NonEmptyString] = Optional.Absent,
    keyName: Optional[NonEmptyString] = Optional.Absent,
    launchConfigurationName: Optional[NonEmptyString] = Optional.Absent,
    placementTenancy: Optional[NonEmptyString] = Optional.Absent,
    ramdiskId: Optional[NonEmptyString] = Optional.Absent,
    securityGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    spotPrice: Optional[NonEmptyString] = Optional.Absent,
    userData: Optional[NonEmptyString] = Optional.Absent,
    metadataOptions: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails = {
    import AwsAutoScalingLaunchConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        classicLinkVpcId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.classicLinkVpcId)
      .optionallyWith(
        classicLinkVpcSecurityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.classicLinkVpcSecurityGroups)
      .optionallyWith(
        createdTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdTime)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(
        iamInstanceProfile.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.iamInstanceProfile)
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceMonitoring.map(value => value.buildAwsValue()))(
        _.instanceMonitoring
      )
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        kernelId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        launchConfigurationName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchConfigurationName)
      .optionallyWith(
        placementTenancy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.placementTenancy)
      .optionallyWith(
        ramdiskId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        spotPrice.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.spotPrice)
      .optionallyWith(
        userData.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userData)
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingLaunchConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails =
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails(
        associatePublicIpAddress.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        classicLinkVpcId.map(value => value),
        classicLinkVpcSecurityGroups.map(value => value),
        createdTime.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value),
        imageId.map(value => value),
        instanceMonitoring.map(value => value.asEditable),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        launchConfigurationName.map(value => value),
        placementTenancy.map(value => value),
        ramdiskId.map(value => value),
        securityGroups.map(value => value),
        spotPrice.map(value => value),
        userData.map(value => value),
        metadataOptions.map(value => value.asEditable)
      )
    def associatePublicIpAddress: Optional[Boolean]
    def blockDeviceMappings: Optional[List[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly
    ]]
    def classicLinkVpcId: Optional[NonEmptyString]
    def classicLinkVpcSecurityGroups: Optional[List[NonEmptyString]]
    def createdTime: Optional[NonEmptyString]
    def ebsOptimized: Optional[Boolean]
    def iamInstanceProfile: Optional[NonEmptyString]
    def imageId: Optional[NonEmptyString]
    def instanceMonitoring: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly
    ]
    def instanceType: Optional[NonEmptyString]
    def kernelId: Optional[NonEmptyString]
    def keyName: Optional[NonEmptyString]
    def launchConfigurationName: Optional[NonEmptyString]
    def placementTenancy: Optional[NonEmptyString]
    def ramdiskId: Optional[NonEmptyString]
    def securityGroups: Optional[List[NonEmptyString]]
    def spotPrice: Optional[NonEmptyString]
    def userData: Optional[NonEmptyString]
    def metadataOptions: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly
    ]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getClassicLinkVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("classicLinkVpcId", classicLinkVpcId)
    def getClassicLinkVpcSecurityGroups
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "classicLinkVpcSecurityGroups",
      classicLinkVpcSecurityGroups
    )
    def getCreatedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly
    ] = AwsError.unwrapOptionField("instanceMonitoring", instanceMonitoring)
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getLaunchConfigurationName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "launchConfigurationName",
        launchConfigurationName
      )
    def getPlacementTenancy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("placementTenancy", placementTenancy)
    def getRamdiskId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSpotPrice: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getUserData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userData", userData)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly {
    override val associatePublicIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value => value: Boolean)
    override val blockDeviceMappings: Optional[List[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
            .wrap(item)
        }.toList
      )
    override val classicLinkVpcId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classicLinkVpcId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val classicLinkVpcSecurityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classicLinkVpcSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val createdTime: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val iamInstanceProfile: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val imageId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceMonitoring: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMonitoring())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
          .wrap(value)
      )
    override val instanceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kernelId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val launchConfigurationName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchConfigurationName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val placementTenancy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementTenancy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val ramdiskId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val spotPrice: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.spotPrice())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userData: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val metadataOptions: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
  ): zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
