package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(
    launchTemplateSpecification: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
    ] = Optional.Absent,
    overrides: Optional[Iterable[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails = {
    import AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
      .builder()
      .optionallyWith(
        launchTemplateSpecification.map(value => value.buildAwsValue())
      )(_.launchTemplateSpecification)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(
          launchTemplateSpecification.map(value => value.asEditable),
          overrides.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def launchTemplateSpecification: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly
    ]
    def overrides: Optional[List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly
    ]]
    def getLaunchTemplateSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateSpecification",
      launchTemplateSpecification
    )
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly {
    override val launchTemplateSpecification: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateSpecification())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
          .wrap(value)
      )
    override val overrides: Optional[List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.overrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly =
    new Wrapper(impl)
}
