package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayV2StageDetails(
    clientCertificateId: Optional[NonEmptyString] = Optional.Absent,
    createdDate: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    defaultRouteSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings
    ] = Optional.Absent,
    deploymentId: Optional[NonEmptyString] = Optional.Absent,
    lastUpdatedDate: Optional[NonEmptyString] = Optional.Absent,
    routeSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings
    ] = Optional.Absent,
    stageName: Optional[NonEmptyString] = Optional.Absent,
    stageVariables: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    accessLogSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings
    ] = Optional.Absent,
    autoDeploy: Optional[Boolean] = Optional.Absent,
    lastDeploymentStatusMessage: Optional[NonEmptyString] = Optional.Absent,
    apiGatewayManaged: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails = {
    import AwsApiGatewayV2StageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
      .builder()
      .optionallyWith(
        clientCertificateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clientCertificateId)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(defaultRouteSettings.map(value => value.buildAwsValue()))(
        _.defaultRouteSettings
      )
      .optionallyWith(
        deploymentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deploymentId)
      .optionallyWith(
        lastUpdatedDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedDate)
      .optionallyWith(routeSettings.map(value => value.buildAwsValue()))(
        _.routeSettings
      )
      .optionallyWith(
        stageName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(autoDeploy.map(value => value: java.lang.Boolean))(
        _.autoDeploy
      )
      .optionallyWith(
        lastDeploymentStatusMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastDeploymentStatusMessage)
      .optionallyWith(apiGatewayManaged.map(value => value: java.lang.Boolean))(
        _.apiGatewayManaged
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.wrap(buildAwsValue())
}
object AwsApiGatewayV2StageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayV2StageDetails =
      zio.aws.securityhub.model.AwsApiGatewayV2StageDetails(
        clientCertificateId.map(value => value),
        createdDate.map(value => value),
        description.map(value => value),
        defaultRouteSettings.map(value => value.asEditable),
        deploymentId.map(value => value),
        lastUpdatedDate.map(value => value),
        routeSettings.map(value => value.asEditable),
        stageName.map(value => value),
        stageVariables.map(value => value),
        accessLogSettings.map(value => value.asEditable),
        autoDeploy.map(value => value),
        lastDeploymentStatusMessage.map(value => value),
        apiGatewayManaged.map(value => value)
      )
    def clientCertificateId: Optional[NonEmptyString]
    def createdDate: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def defaultRouteSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ]
    def deploymentId: Optional[NonEmptyString]
    def lastUpdatedDate: Optional[NonEmptyString]
    def routeSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ]
    def stageName: Optional[NonEmptyString]
    def stageVariables: Optional[Map[NonEmptyString, NonEmptyString]]
    def accessLogSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ]
    def autoDeploy: Optional[Boolean]
    def lastDeploymentStatusMessage: Optional[NonEmptyString]
    def apiGatewayManaged: Optional[Boolean]
    def getClientCertificateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultRouteSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = AwsError.unwrapOptionField("defaultRouteSettings", defaultRouteSettings)
    def getDeploymentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getLastUpdatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getRouteSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = AwsError.unwrapOptionField("routeSettings", routeSettings)
    def getStageName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getStageVariables
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getAutoDeploy: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoDeploy", autoDeploy)
    def getLastDeploymentStatusMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "lastDeploymentStatusMessage",
        lastDeploymentStatusMessage
      )
    def getApiGatewayManaged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly {
    override val clientCertificateId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientCertificateId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val createdDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultRouteSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultRouteSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.wrap(value)
      )
    override val deploymentId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastUpdatedDate: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDate())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val routeSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routeSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.wrap(value)
      )
    override val stageName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stageVariables: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val accessLogSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessLogSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.wrap(value)
      )
    override val autoDeploy: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoDeploy())
      .map(value => value: Boolean)
    override val lastDeploymentStatusMessage: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentStatusMessage())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val apiGatewayManaged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.apiGatewayManaged())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
  ): zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly =
    new Wrapper(impl)
}
