package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayV2ApiDetails(
    apiEndpoint: Optional[NonEmptyString] = Optional.Absent,
    apiId: Optional[NonEmptyString] = Optional.Absent,
    apiKeySelectionExpression: Optional[NonEmptyString] = Optional.Absent,
    createdDate: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    protocolType: Optional[NonEmptyString] = Optional.Absent,
    routeSelectionExpression: Optional[NonEmptyString] = Optional.Absent,
    corsConfiguration: Optional[
      zio.aws.securityhub.model.AwsCorsConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails = {
    import AwsApiGatewayV2ApiDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
      .builder()
      .optionallyWith(
        apiEndpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.apiEndpoint)
      .optionallyWith(
        apiId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.apiId)
      .optionallyWith(
        apiKeySelectionExpression.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.apiKeySelectionExpression)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        protocolType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.protocolType)
      .optionallyWith(
        routeSelectionExpression.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.routeSelectionExpression)
      .optionallyWith(corsConfiguration.map(value => value.buildAwsValue()))(
        _.corsConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.wrap(buildAwsValue())
}
object AwsApiGatewayV2ApiDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails =
      zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails(
        apiEndpoint.map(value => value),
        apiId.map(value => value),
        apiKeySelectionExpression.map(value => value),
        createdDate.map(value => value),
        description.map(value => value),
        version.map(value => value),
        name.map(value => value),
        protocolType.map(value => value),
        routeSelectionExpression.map(value => value),
        corsConfiguration.map(value => value.asEditable)
      )
    def apiEndpoint: Optional[NonEmptyString]
    def apiId: Optional[NonEmptyString]
    def apiKeySelectionExpression: Optional[NonEmptyString]
    def createdDate: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def protocolType: Optional[NonEmptyString]
    def routeSelectionExpression: Optional[NonEmptyString]
    def corsConfiguration
        : Optional[zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly]
    def getApiEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("apiEndpoint", apiEndpoint)
    def getApiId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiKeySelectionExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "apiKeySelectionExpression",
        apiKeySelectionExpression
      )
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getProtocolType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocolType", protocolType)
    def getRouteSelectionExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "routeSelectionExpression",
        routeSelectionExpression
      )
    def getCorsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("corsConfiguration", corsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly {
    override val apiEndpoint: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.apiEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val apiId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.apiId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val apiKeySelectionExpression: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeySelectionExpression())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val createdDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocolType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocolType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val routeSelectionExpression: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeSelectionExpression())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val corsConfiguration
        : Optional[zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.corsConfiguration())
        .map(value =>
          zio.aws.securityhub.model.AwsCorsConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
  ): zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly = new Wrapper(
    impl
  )
}
