package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait StatusReasonCode {
  def unwrap: software.amazon.awssdk.services.securityhub.model.StatusReasonCode
}
object StatusReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.StatusReasonCode
  ): zio.aws.securityhub.model.StatusReasonCode = value match {
    case software.amazon.awssdk.services.securityhub.model.StatusReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.StatusReasonCode.NO_AVAILABLE_CONFIGURATION_RECORDER =>
      val r = NO_AVAILABLE_CONFIGURATION_RECORDER
      r
    case software.amazon.awssdk.services.securityhub.model.StatusReasonCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.StatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StatusReasonCode =
      software.amazon.awssdk.services.securityhub.model.StatusReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_AVAILABLE_CONFIGURATION_RECORDER
      extends zio.aws.securityhub.model.StatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StatusReasonCode =
      software.amazon.awssdk.services.securityhub.model.StatusReasonCode.NO_AVAILABLE_CONFIGURATION_RECORDER
  }
  case object INTERNAL_ERROR
      extends zio.aws.securityhub.model.StatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StatusReasonCode =
      software.amazon.awssdk.services.securityhub.model.StatusReasonCode.INTERNAL_ERROR
  }
}
