package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StatelessCustomPublishMetricActionDimension(
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension = {
    import StatelessCustomPublishMetricActionDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
      .builder()
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly =
    zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension
      .wrap(buildAwsValue())
}
object StatelessCustomPublishMetricActionDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension =
      zio.aws.securityhub.model
        .StatelessCustomPublishMetricActionDimension(value.map(value => value))
    def value: Optional[NonEmptyString]
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
  ) extends zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly {
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
  ): zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly =
    new Wrapper(impl)
}
