package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.RatioScale
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SeverityUpdate(
    normalized: Optional[RatioScale] = Optional.Absent,
    product: Optional[Double] = Optional.Absent,
    label: Optional[zio.aws.securityhub.model.SeverityLabel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SeverityUpdate = {
    import SeverityUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SeverityUpdate
      .builder()
      .optionallyWith(
        normalized.map(value => RatioScale.unwrap(value): Integer)
      )(_.normalized)
      .optionallyWith(product.map(value => value: java.lang.Double))(_.product)
      .optionallyWith(label.map(value => value.unwrap))(_.label)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SeverityUpdate.ReadOnly =
    zio.aws.securityhub.model.SeverityUpdate.wrap(buildAwsValue())
}
object SeverityUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SeverityUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SeverityUpdate =
      zio.aws.securityhub.model.SeverityUpdate(
        normalized.map(value => value),
        product.map(value => value),
        label.map(value => value)
      )
    def normalized: Optional[RatioScale]
    def product: Optional[Double]
    def label: Optional[zio.aws.securityhub.model.SeverityLabel]
    def getNormalized: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("normalized", normalized)
    def getProduct: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("product", product)
    def getLabel: ZIO[Any, AwsError, zio.aws.securityhub.model.SeverityLabel] =
      AwsError.unwrapOptionField("label", label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SeverityUpdate
  ) extends zio.aws.securityhub.model.SeverityUpdate.ReadOnly {
    override val normalized: Optional[RatioScale] = zio.aws.core.internal
      .optionalFromNullable(impl.normalized())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val product: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.product())
      .map(value => value: Double)
    override val label: Optional[zio.aws.securityhub.model.SeverityLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.label())
        .map(value => zio.aws.securityhub.model.SeverityLabel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SeverityUpdate
  ): zio.aws.securityhub.model.SeverityUpdate.ReadOnly = new Wrapper(impl)
}
