package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRuleMatchAttributesTcpFlags(
    flags: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    masks: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags = {
    import RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
      .builder()
      .optionallyWith(
        flags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.flags)
      .optionallyWith(
        masks.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.masks)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRuleMatchAttributesTcpFlags {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags =
      zio.aws.securityhub.model
        .RuleGroupSourceStatelessRuleMatchAttributesTcpFlags(
          flags.map(value => value),
          masks.map(value => value)
        )
    def flags: Optional[List[NonEmptyString]]
    def masks: Optional[List[NonEmptyString]]
    def getFlags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("flags", flags)
    def getMasks: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("masks", masks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.ReadOnly {
    override val flags: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.flags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val masks: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.masks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.ReadOnly =
    new Wrapper(impl)
}
