package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceListDetails(
    generatedRulesType: Optional[NonEmptyString] = Optional.Absent,
    targetTypes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    targets: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails = {
    import RuleGroupSourceListDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
      .builder()
      .optionallyWith(
        generatedRulesType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.generatedRulesType)
      .optionallyWith(
        targetTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetTypes)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targets)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceListDetails.wrap(buildAwsValue())
}
object RuleGroupSourceListDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupSourceListDetails =
      zio.aws.securityhub.model.RuleGroupSourceListDetails(
        generatedRulesType.map(value => value),
        targetTypes.map(value => value),
        targets.map(value => value)
      )
    def generatedRulesType: Optional[NonEmptyString]
    def targetTypes: Optional[List[NonEmptyString]]
    def targets: Optional[List[NonEmptyString]]
    def getGeneratedRulesType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("generatedRulesType", generatedRulesType)
    def getTargetTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("targetTypes", targetTypes)
    def getTargets: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("targets", targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly {
    override val generatedRulesType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generatedRulesType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val targetTypes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val targets: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
  ): zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly =
    new Wrapper(impl)
}
