package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ipv6CidrBlockAssociation(
    associationId: Optional[NonEmptyString] = Optional.Absent,
    ipv6CidrBlock: Optional[NonEmptyString] = Optional.Absent,
    cidrBlockState: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation = {
    import Ipv6CidrBlockAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        ipv6CidrBlock.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ipv6CidrBlock)
      .optionallyWith(
        cidrBlockState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cidrBlockState)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly =
    zio.aws.securityhub.model.Ipv6CidrBlockAssociation.wrap(buildAwsValue())
}
object Ipv6CidrBlockAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Ipv6CidrBlockAssociation =
      zio.aws.securityhub.model.Ipv6CidrBlockAssociation(
        associationId.map(value => value),
        ipv6CidrBlock.map(value => value),
        cidrBlockState.map(value => value)
      )
    def associationId: Optional[NonEmptyString]
    def ipv6CidrBlock: Optional[NonEmptyString]
    def cidrBlockState: Optional[NonEmptyString]
    def getAssociationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getIpv6CidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getCidrBlockState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrBlockState", cidrBlockState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation
  ) extends zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly {
    override val associationId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipv6CidrBlock: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cidrBlockState: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrBlockState())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation
  ): zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly = new Wrapper(
    impl
  )
}
