package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeOrganizationConfigurationResponse(
    autoEnable: Optional[Boolean] = Optional.Absent,
    memberAccountLimitReached: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse = {
    import DescribeOrganizationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse
      .builder()
      .optionallyWith(autoEnable.map(value => value: java.lang.Boolean))(
        _.autoEnable
      )
      .optionallyWith(
        memberAccountLimitReached.map(value => value: java.lang.Boolean)
      )(_.memberAccountLimitReached)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse =
      zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse(
        autoEnable.map(value => value),
        memberAccountLimitReached.map(value => value)
      )
    def autoEnable: Optional[Boolean]
    def memberAccountLimitReached: Optional[Boolean]
    def getAutoEnable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
    def getMemberAccountLimitReached: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("memberAccountLimitReached", memberAccountLimitReached)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse
  ) extends zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly {
    override val autoEnable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnable())
      .map(value => value: Boolean)
    override val memberAccountLimitReached: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberAccountLimitReached())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse
  ): zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
