package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFindingAggregatorRequest(
    regionLinkingMode: NonEmptyString,
    regions: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest = {
    import CreateFindingAggregatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest
      .builder()
      .regionLinkingMode(
        NonEmptyString.unwrap(regionLinkingMode): java.lang.String
      )
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CreateFindingAggregatorRequest.ReadOnly =
    zio.aws.securityhub.model.CreateFindingAggregatorRequest
      .wrap(buildAwsValue())
}
object CreateFindingAggregatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateFindingAggregatorRequest =
      zio.aws.securityhub.model.CreateFindingAggregatorRequest(
        regionLinkingMode,
        regions.map(value => value)
      )
    def regionLinkingMode: NonEmptyString
    def regions: Optional[List[NonEmptyString]]
    def getRegionLinkingMode: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(regionLinkingMode)
    def getRegions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest
  ) extends zio.aws.securityhub.model.CreateFindingAggregatorRequest.ReadOnly {
    override val regionLinkingMode: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.regionLinkingMode())
    override val regions: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest
  ): zio.aws.securityhub.model.CreateFindingAggregatorRequest.ReadOnly =
    new Wrapper(impl)
}
