package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3ObjectDetails(
    lastModified: Optional[NonEmptyString] = Optional.Absent,
    eTag: Optional[NonEmptyString] = Optional.Absent,
    versionId: Optional[NonEmptyString] = Optional.Absent,
    contentType: Optional[NonEmptyString] = Optional.Absent,
    serverSideEncryption: Optional[NonEmptyString] = Optional.Absent,
    ssekmsKeyId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails = {
    import AwsS3ObjectDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
      .builder()
      .optionallyWith(
        lastModified.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastModified)
      .optionallyWith(
        eTag.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.eTag)
      .optionallyWith(
        versionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        contentType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        serverSideEncryption.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.serverSideEncryption)
      .optionallyWith(
        ssekmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3ObjectDetails.wrap(buildAwsValue())
}
object AwsS3ObjectDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsS3ObjectDetails =
      zio.aws.securityhub.model.AwsS3ObjectDetails(
        lastModified.map(value => value),
        eTag.map(value => value),
        versionId.map(value => value),
        contentType.map(value => value),
        serverSideEncryption.map(value => value),
        ssekmsKeyId.map(value => value)
      )
    def lastModified: Optional[NonEmptyString]
    def eTag: Optional[NonEmptyString]
    def versionId: Optional[NonEmptyString]
    def contentType: Optional[NonEmptyString]
    def serverSideEncryption: Optional[NonEmptyString]
    def ssekmsKeyId: Optional[NonEmptyString]
    def getLastModified: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getETag: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getVersionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getContentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getServerSideEncryption: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSsekmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
  ) extends zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly {
    override val lastModified: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val eTag: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val versionId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val contentType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serverSideEncryption: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val ssekmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
  ): zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly = new Wrapper(impl)
}
