package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketServerSideEncryptionByDefault(
    sseAlgorithm: Optional[NonEmptyString] = Optional.Absent,
    kmsMasterKeyID: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionByDefault = {
    import AwsS3BucketServerSideEncryptionByDefault.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionByDefault
      .builder()
      .optionallyWith(
        sseAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sseAlgorithm)
      .optionallyWith(
        kmsMasterKeyID.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyID)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault
      .wrap(buildAwsValue())
}
object AwsS3BucketServerSideEncryptionByDefault {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionByDefault
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault =
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault(
        sseAlgorithm.map(value => value),
        kmsMasterKeyID.map(value => value)
      )
    def sseAlgorithm: Optional[NonEmptyString]
    def kmsMasterKeyID: Optional[NonEmptyString]
    def getSseAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sseAlgorithm", sseAlgorithm)
    def getKmsMasterKeyID: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsMasterKeyID", kmsMasterKeyID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionByDefault
  ) extends zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault.ReadOnly {
    override val sseAlgorithm: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sseAlgorithm())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsMasterKeyID: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsMasterKeyID())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionByDefault
  ): zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionByDefault.ReadOnly =
    new Wrapper(impl)
}
