package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterPendingModifiedValues(
    automatedSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    clusterIdentifier: Optional[NonEmptyString] = Optional.Absent,
    clusterType: Optional[NonEmptyString] = Optional.Absent,
    clusterVersion: Optional[NonEmptyString] = Optional.Absent,
    encryptionType: Optional[NonEmptyString] = Optional.Absent,
    enhancedVpcRouting: Optional[Boolean] = Optional.Absent,
    maintenanceTrackName: Optional[NonEmptyString] = Optional.Absent,
    masterUserPassword: Optional[NonEmptyString] = Optional.Absent,
    nodeType: Optional[NonEmptyString] = Optional.Absent,
    numberOfNodes: Optional[Integer] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues = {
    import AwsRedshiftClusterPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
      .builder()
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        clusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterIdentifier)
      .optionallyWith(
        clusterType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clusterType)
      .optionallyWith(
        clusterVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterVersion)
      .optionallyWith(
        encryptionType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionType)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.maintenanceTrackName)
      .optionallyWith(
        masterUserPassword.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(
        nodeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nodeType)
      .optionallyWith(numberOfNodes.map(value => value: java.lang.Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues =
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues(
        automatedSnapshotRetentionPeriod.map(value => value),
        clusterIdentifier.map(value => value),
        clusterType.map(value => value),
        clusterVersion.map(value => value),
        encryptionType.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        masterUserPassword.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        publiclyAccessible.map(value => value)
      )
    def automatedSnapshotRetentionPeriod: Optional[Integer]
    def clusterIdentifier: Optional[NonEmptyString]
    def clusterType: Optional[NonEmptyString]
    def clusterVersion: Optional[NonEmptyString]
    def encryptionType: Optional[NonEmptyString]
    def enhancedVpcRouting: Optional[Boolean]
    def maintenanceTrackName: Optional[NonEmptyString]
    def masterUserPassword: Optional[NonEmptyString]
    def nodeType: Optional[NonEmptyString]
    def numberOfNodes: Optional[Integer]
    def publiclyAccessible: Optional[Boolean]
    def getAutomatedSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "automatedSnapshotRetentionPeriod",
        automatedSnapshotRetentionPeriod
      )
    def getClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getClusterVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getEncryptionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getMasterUserPassword: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getNodeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly {
    override val automatedSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val clusterIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val clusterType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val encryptionType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val enhancedVpcRouting: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedVpcRouting())
      .map(value => value: Boolean)
    override val maintenanceTrackName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceTrackName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val masterUserPassword: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserPassword())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val nodeType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val numberOfNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfNodes())
      .map(value => value: Integer)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
  ): zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly =
    new Wrapper(impl)
}
