package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSnapshotDetails(
    dbSnapshotIdentifier: Optional[NonEmptyString] = Optional.Absent,
    dbInstanceIdentifier: Optional[NonEmptyString] = Optional.Absent,
    snapshotCreateTime: Optional[NonEmptyString] = Optional.Absent,
    engine: Optional[NonEmptyString] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    availabilityZone: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    instanceCreateTime: Optional[NonEmptyString] = Optional.Absent,
    masterUsername: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    licenseModel: Optional[NonEmptyString] = Optional.Absent,
    snapshotType: Optional[NonEmptyString] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    optionGroupName: Optional[NonEmptyString] = Optional.Absent,
    percentProgress: Optional[Integer] = Optional.Absent,
    sourceRegion: Optional[NonEmptyString] = Optional.Absent,
    sourceDbSnapshotIdentifier: Optional[NonEmptyString] = Optional.Absent,
    storageType: Optional[NonEmptyString] = Optional.Absent,
    tdeCredentialArn: Optional[NonEmptyString] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    timezone: Optional[NonEmptyString] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    processorFeatures: Optional[
      Iterable[zio.aws.securityhub.model.AwsRdsDbProcessorFeature]
    ] = Optional.Absent,
    dbiResourceId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails = {
    import AwsRdsDbSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
      .builder()
      .optionallyWith(
        dbSnapshotIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSnapshotIdentifier)
      .optionallyWith(
        dbInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        snapshotCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotCreateTime)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        instanceCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceCreateTime)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(
        snapshotType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotType)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        optionGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.optionGroupName)
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(
        sourceRegion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceRegion)
      .optionallyWith(
        sourceDbSnapshotIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceDbSnapshotIdentifier)
      .optionallyWith(
        storageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        tdeCredentialArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tdeCredentialArn)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        timezone.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        dbiResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbiResourceId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.wrap(buildAwsValue())
}
object AwsRdsDbSnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbSnapshotDetails =
      zio.aws.securityhub.model.AwsRdsDbSnapshotDetails(
        dbSnapshotIdentifier.map(value => value),
        dbInstanceIdentifier.map(value => value),
        snapshotCreateTime.map(value => value),
        engine.map(value => value),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        vpcId.map(value => value),
        instanceCreateTime.map(value => value),
        masterUsername.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        snapshotType.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        percentProgress.map(value => value),
        sourceRegion.map(value => value),
        sourceDbSnapshotIdentifier.map(value => value),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        timezone.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbiResourceId.map(value => value)
      )
    def dbSnapshotIdentifier: Optional[NonEmptyString]
    def dbInstanceIdentifier: Optional[NonEmptyString]
    def snapshotCreateTime: Optional[NonEmptyString]
    def engine: Optional[NonEmptyString]
    def allocatedStorage: Optional[Integer]
    def status: Optional[NonEmptyString]
    def port: Optional[Integer]
    def availabilityZone: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def instanceCreateTime: Optional[NonEmptyString]
    def masterUsername: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def licenseModel: Optional[NonEmptyString]
    def snapshotType: Optional[NonEmptyString]
    def iops: Optional[Integer]
    def optionGroupName: Optional[NonEmptyString]
    def percentProgress: Optional[Integer]
    def sourceRegion: Optional[NonEmptyString]
    def sourceDbSnapshotIdentifier: Optional[NonEmptyString]
    def storageType: Optional[NonEmptyString]
    def tdeCredentialArn: Optional[NonEmptyString]
    def encrypted: Optional[Boolean]
    def kmsKeyId: Optional[NonEmptyString]
    def timezone: Optional[NonEmptyString]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def processorFeatures: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ]
    def dbiResourceId: Optional[NonEmptyString]
    def getDbSnapshotIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifier)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstanceCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getSourceRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getSourceDbSnapshotIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "sourceDbSnapshotIdentifier",
        sourceDbSnapshotIdentifier
      )
    def getStorageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTimezone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getDbiResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly {
    override val dbSnapshotIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSnapshotIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dbInstanceIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val snapshotCreateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotCreateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val engine: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val availabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceCreateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCreateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val masterUsername: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUsername())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val licenseModel: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snapshotType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val optionGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val percentProgress: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentProgress())
      .map(value => value: Integer)
    override val sourceRegion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRegion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceDbSnapshotIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDbSnapshotIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val storageType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tdeCredentialArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tdeCredentialArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timezone: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val processorFeatures: Optional[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.processorFeatures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbProcessorFeature.wrap(item)
        }.toList
      )
    override val dbiResourceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
  ): zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly = new Wrapper(
    impl
  )
}
