package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSecurityGroupEc2SecurityGroup(
    ec2SecurityGroupId: Optional[NonEmptyString] = Optional.Absent,
    ec2SecurityGroupName: Optional[NonEmptyString] = Optional.Absent,
    ec2SecurityGroupOwnerId: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup = {
    import AwsRdsDbSecurityGroupEc2SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup
      .builder()
      .optionallyWith(
        ec2SecurityGroupId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ec2SecurityGroupId)
      .optionallyWith(
        ec2SecurityGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ec2SecurityGroupName)
      .optionallyWith(
        ec2SecurityGroupOwnerId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ec2SecurityGroupOwnerId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup
      .wrap(buildAwsValue())
}
object AwsRdsDbSecurityGroupEc2SecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup =
      zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup(
        ec2SecurityGroupId.map(value => value),
        ec2SecurityGroupName.map(value => value),
        ec2SecurityGroupOwnerId.map(value => value),
        status.map(value => value)
      )
    def ec2SecurityGroupId: Optional[NonEmptyString]
    def ec2SecurityGroupName: Optional[NonEmptyString]
    def ec2SecurityGroupOwnerId: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def getEc2SecurityGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ec2SecurityGroupId", ec2SecurityGroupId)
    def getEc2SecurityGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupName)
    def getEc2SecurityGroupOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "ec2SecurityGroupOwnerId",
        ec2SecurityGroupOwnerId
      )
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup
  ) extends zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup.ReadOnly {
    override val ec2SecurityGroupId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val ec2SecurityGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val ec2SecurityGroupOwnerId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupOwnerId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup
  ): zio.aws.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup.ReadOnly =
    new Wrapper(impl)
}
