package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainLogPublishingOptionsLogConfig(
    cloudWatchLogsLogGroupArn: Optional[NonEmptyString] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig = {
    import AwsElasticsearchDomainLogPublishingOptionsLogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsLogGroupArn)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainLogPublishingOptionsLogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig =
      zio.aws.securityhub.model
        .AwsElasticsearchDomainLogPublishingOptionsLogConfig(
          cloudWatchLogsLogGroupArn.map(value => value),
          enabled.map(value => value)
        )
    def cloudWatchLogsLogGroupArn: Optional[NonEmptyString]
    def enabled: Optional[Boolean]
    def getCloudWatchLogsLogGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "cloudWatchLogsLogGroupArn",
        cloudWatchLogsLogGroupArn
      )
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly {
    override val cloudWatchLogsLogGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogsLogGroupArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
  ): zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly =
    new Wrapper(impl)
}
