package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkInterfaceIpV6AddressDetail(
    ipV6Address: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail = {
    import AwsEc2NetworkInterfaceIpV6AddressDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
      .builder()
      .optionallyWith(
        ipV6Address.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipV6Address)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
      .wrap(buildAwsValue())
}
object AwsEc2NetworkInterfaceIpV6AddressDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail =
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail(
        ipV6Address.map(value => value)
      )
    def ipV6Address: Optional[NonEmptyString]
    def getIpV6Address: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipV6Address", ipV6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
  ) extends zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly {
    override val ipV6Address: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipV6Address())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
  ): zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly =
    new Wrapper(impl)
}
