package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayAccessLogSettings(
    format: Optional[NonEmptyString] = Optional.Absent,
    destinationArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings = {
    import AwsApiGatewayAccessLogSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
      .builder()
      .optionallyWith(
        format.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        destinationArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings
      .wrap(buildAwsValue())
}
object AwsApiGatewayAccessLogSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings =
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings(
        format.map(value => value),
        destinationArn.map(value => value)
      )
    def format: Optional[NonEmptyString]
    def destinationArn: Optional[NonEmptyString]
    def getFormat: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("format", format)
    def getDestinationArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
  ) extends zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly {
    override val format: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
  ): zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly =
    new Wrapper(impl)
}
