package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatefulRulesOptionsDetails(
    keyword: Optional[NonEmptyString] = Optional.Absent,
    settings: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails = {
    import RuleGroupSourceStatefulRulesOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails
      .builder()
      .optionallyWith(
        keyword.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyword)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatefulRulesOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails =
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails(
        keyword.map(value => value),
        settings.map(value => value)
      )
    def keyword: Optional[NonEmptyString]
    def settings: Optional[List[NonEmptyString]]
    def getKeyword: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyword", keyword)
    def getSettings: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails.ReadOnly {
    override val keyword: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyword())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val settings: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails
  ): zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
