package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSource(
    rulesSourceList: Optional[
      zio.aws.securityhub.model.RuleGroupSourceListDetails
    ] = Optional.Absent,
    rulesString: Optional[NonEmptyString] = Optional.Absent,
    statefulRules: Optional[
      Iterable[zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails]
    ] = Optional.Absent,
    statelessRulesAndCustomActions: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSource = {
    import RuleGroupSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSource
      .builder()
      .optionallyWith(rulesSourceList.map(value => value.buildAwsValue()))(
        _.rulesSourceList
      )
      .optionallyWith(
        rulesString.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.rulesString)
      .optionallyWith(
        statefulRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRules)
      .optionallyWith(
        statelessRulesAndCustomActions.map(value => value.buildAwsValue())
      )(_.statelessRulesAndCustomActions)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.RuleGroupSource.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSource.wrap(buildAwsValue())
}
object RuleGroupSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupSource =
      zio.aws.securityhub.model.RuleGroupSource(
        rulesSourceList.map(value => value.asEditable),
        rulesString.map(value => value),
        statefulRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessRulesAndCustomActions.map(value => value.asEditable)
      )
    def rulesSourceList: Optional[
      zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly
    ]
    def rulesString: Optional[NonEmptyString]
    def statefulRules: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly
    ]]
    def statelessRulesAndCustomActions: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly
    ]
    def getRulesSourceList: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly
    ] = AwsError.unwrapOptionField("rulesSourceList", rulesSourceList)
    def getRulesString: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rulesString", rulesString)
    def getStatefulRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("statefulRules", statefulRules)
    def getStatelessRulesAndCustomActions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "statelessRulesAndCustomActions",
      statelessRulesAndCustomActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSource
  ) extends zio.aws.securityhub.model.RuleGroupSource.ReadOnly {
    override val rulesSourceList: Optional[
      zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rulesSourceList())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceListDetails.wrap(value)
      )
    override val rulesString: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.rulesString())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val statefulRules: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statefulRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails
            .wrap(item)
        }.toList
      )
    override val statelessRulesAndCustomActions: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statelessRulesAndCustomActions())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSource
  ): zio.aws.securityhub.model.RuleGroupSource.ReadOnly = new Wrapper(impl)
}
