package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Result(
    accountId: Optional[AccountId] = Optional.Absent,
    processingResult: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Result = {
    import Result.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Result
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        processingResult.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.processingResult)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Result.ReadOnly =
    zio.aws.securityhub.model.Result.wrap(buildAwsValue())
}
object Result {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Result
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Result =
      zio.aws.securityhub.model.Result(
        accountId.map(value => value),
        processingResult.map(value => value)
      )
    def accountId: Optional[AccountId]
    def processingResult: Optional[NonEmptyString]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getProcessingResult: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("processingResult", processingResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Result
  ) extends zio.aws.securityhub.model.Result.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.AccountId(value))
    override val processingResult: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingResult())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Result
  ): zio.aws.securityhub.model.Result.ReadOnly = new Wrapper(impl)
}
