package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    imageId: Optional[NonEmptyString] = Optional.Absent,
    imageName: Optional[NonEmptyString] = Optional.Absent,
    launchedAt: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ContainerDetails = {
    import ContainerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ContainerDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        imageName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageName)
      .optionallyWith(
        launchedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.launchedAt)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ContainerDetails.ReadOnly =
    zio.aws.securityhub.model.ContainerDetails.wrap(buildAwsValue())
}
object ContainerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ContainerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ContainerDetails =
      zio.aws.securityhub.model.ContainerDetails(
        name.map(value => value),
        imageId.map(value => value),
        imageName.map(value => value),
        launchedAt.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def imageId: Optional[NonEmptyString]
    def imageName: Optional[NonEmptyString]
    def launchedAt: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImageName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getLaunchedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ContainerDetails
  ) extends zio.aws.securityhub.model.ContainerDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val launchedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.launchedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ContainerDetails
  ): zio.aws.securityhub.model.ContainerDetails.ReadOnly = new Wrapper(impl)
}
