package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(
    operands: Optional[Iterable[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
    ]] = Optional.Absent,
    prefix: Optional[NonEmptyString] = Optional.Absent,
    tag: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
    ] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
      .builder()
      .optionallyWith(
        operands.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operands)
      .optionallyWith(
        prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(
          operands.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          prefix.map(value => value),
          tag.map(value => value.asEditable),
          `type`.map(value => value)
        )
    def operands: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly
    ]]
    def prefix: Optional[NonEmptyString]
    def tag: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly
    ]
    def `type`: Optional[NonEmptyString]
    def getOperands: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("operands", operands)
    def getPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly
    ] = AwsError.unwrapOptionField("tag", tag)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly {
    override val operands: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.operands())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
            .wrap(item)
        }.toList
      )
    override val prefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tag: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tag())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
          .wrap(value)
      )
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly =
    new Wrapper(impl)
}
