package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterLoggingStatus(
    bucketName: Optional[NonEmptyString] = Optional.Absent,
    lastFailureMessage: Optional[NonEmptyString] = Optional.Absent,
    lastFailureTime: Optional[NonEmptyString] = Optional.Absent,
    lastSuccessfulDeliveryTime: Optional[NonEmptyString] = Optional.Absent,
    loggingEnabled: Optional[Boolean] = Optional.Absent,
    s3KeyPrefix: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterLoggingStatus = {
    import AwsRedshiftClusterLoggingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterLoggingStatus
      .builder()
      .optionallyWith(
        bucketName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bucketName)
      .optionallyWith(
        lastFailureMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastFailureMessage)
      .optionallyWith(
        lastFailureTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastFailureTime)
      .optionallyWith(
        lastSuccessfulDeliveryTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulDeliveryTime)
      .optionallyWith(loggingEnabled.map(value => value: java.lang.Boolean))(
        _.loggingEnabled
      )
      .optionallyWith(
        s3KeyPrefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterLoggingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterLoggingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus =
      zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus(
        bucketName.map(value => value),
        lastFailureMessage.map(value => value),
        lastFailureTime.map(value => value),
        lastSuccessfulDeliveryTime.map(value => value),
        loggingEnabled.map(value => value),
        s3KeyPrefix.map(value => value)
      )
    def bucketName: Optional[NonEmptyString]
    def lastFailureMessage: Optional[NonEmptyString]
    def lastFailureTime: Optional[NonEmptyString]
    def lastSuccessfulDeliveryTime: Optional[NonEmptyString]
    def loggingEnabled: Optional[Boolean]
    def s3KeyPrefix: Optional[NonEmptyString]
    def getBucketName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getLastFailureMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getLastFailureTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastFailureTime", lastFailureTime)
    def getLastSuccessfulDeliveryTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "lastSuccessfulDeliveryTime",
        lastSuccessfulDeliveryTime
      )
    def getLoggingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("loggingEnabled", loggingEnabled)
    def getS3KeyPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterLoggingStatus
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus.ReadOnly {
    override val bucketName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastFailureMessage: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastFailureMessage())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lastFailureTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastFailureTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lastSuccessfulDeliveryTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulDeliveryTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val loggingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingEnabled())
      .map(value => value: Boolean)
    override val s3KeyPrefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterLoggingStatus
  ): zio.aws.securityhub.model.AwsRedshiftClusterLoggingStatus.ReadOnly =
    new Wrapper(impl)
}
