package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterClusterParameterGroup(
    clusterParameterStatusList: Optional[Iterable[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus
    ]] = Optional.Absent,
    parameterApplyStatus: Optional[NonEmptyString] = Optional.Absent,
    parameterGroupName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup = {
    import AwsRedshiftClusterClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
      .builder()
      .optionallyWith(
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterStatusList)
      .optionallyWith(
        parameterApplyStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterApplyStatus)
      .optionallyWith(
        parameterGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup =
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup(
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameterApplyStatus.map(value => value),
        parameterGroupName.map(value => value)
      )
    def clusterParameterStatusList: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly
    ]]
    def parameterApplyStatus: Optional[NonEmptyString]
    def parameterGroupName: Optional[NonEmptyString]
    def getClusterParameterStatusList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterStatusList",
      clusterParameterStatusList
    )
    def getParameterApplyStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getParameterGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly {
    override val clusterParameterStatusList: Optional[List[
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterParameterStatusList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus
            .wrap(item)
        }.toList
      )
    override val parameterApplyStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterApplyStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val parameterGroupName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterGroupName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup
  ): zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterGroup.ReadOnly =
    new Wrapper(impl)
}
