package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(
    containerPath: Optional[NonEmptyString] = Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent,
    sourceVolume: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
      .builder()
      .optionallyWith(
        containerPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerPath)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        sourceVolume.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceVolume)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(
          containerPath.map(value => value),
          readOnly.map(value => value),
          sourceVolume.map(value => value)
        )
    def containerPath: Optional[NonEmptyString]
    def readOnly: Optional[Boolean]
    def sourceVolume: Optional[NonEmptyString]
    def getContainerPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getSourceVolume: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceVolume", sourceVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly {
    override val containerPath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
    override val sourceVolume: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVolume())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly =
    new Wrapper(impl)
}
