package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(
    assignPublicIp: Optional[NonEmptyString] = Optional.Absent,
    securityGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    subnets: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails = {
    import AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
      .builder()
      .optionallyWith(
        assignPublicIp.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.assignPublicIp)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(
          assignPublicIp.map(value => value),
          securityGroups.map(value => value),
          subnets.map(value => value)
        )
    def assignPublicIp: Optional[NonEmptyString]
    def securityGroups: Optional[List[NonEmptyString]]
    def subnets: Optional[List[NonEmptyString]]
    def getAssignPublicIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("assignPublicIp", assignPublicIp)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnets: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.ReadOnly {
    override val assignPublicIp: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignPublicIp())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val securityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val subnets: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
