package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectArtifactsDetails(
    artifactIdentifier: Optional[NonEmptyString] = Optional.Absent,
    encryptionDisabled: Optional[Boolean] = Optional.Absent,
    location: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    namespaceType: Optional[NonEmptyString] = Optional.Absent,
    overrideArtifactName: Optional[Boolean] = Optional.Absent,
    packaging: Optional[NonEmptyString] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails = {
    import AwsCodeBuildProjectArtifactsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
      .builder()
      .optionallyWith(
        artifactIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.artifactIdentifier)
      .optionallyWith(
        encryptionDisabled.map(value => value: java.lang.Boolean)
      )(_.encryptionDisabled)
      .optionallyWith(
        location.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        namespaceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.namespaceType)
      .optionallyWith(
        overrideArtifactName.map(value => value: java.lang.Boolean)
      )(_.overrideArtifactName)
      .optionallyWith(
        packaging.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.packaging)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectArtifactsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails =
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails(
        artifactIdentifier.map(value => value),
        encryptionDisabled.map(value => value),
        location.map(value => value),
        name.map(value => value),
        namespaceType.map(value => value),
        overrideArtifactName.map(value => value),
        packaging.map(value => value),
        path.map(value => value),
        `type`.map(value => value)
      )
    def artifactIdentifier: Optional[NonEmptyString]
    def encryptionDisabled: Optional[Boolean]
    def location: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def namespaceType: Optional[NonEmptyString]
    def overrideArtifactName: Optional[Boolean]
    def packaging: Optional[NonEmptyString]
    def path: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def getArtifactIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("artifactIdentifier", artifactIdentifier)
    def getEncryptionDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getLocation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("location", location)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getNamespaceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("namespaceType", namespaceType)
    def getOverrideArtifactName: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("overrideArtifactName", overrideArtifactName)
    def getPackaging: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packaging", packaging)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly {
    override val artifactIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val encryptionDisabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionDisabled())
      .map(value => value: Boolean)
    override val location: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val namespaceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val overrideArtifactName: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.overrideArtifactName())
      .map(value => value: Boolean)
    override val packaging: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.packaging())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly =
    new Wrapper(impl)
}
