package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayStageDetails(
    deploymentId: Optional[NonEmptyString] = Optional.Absent,
    clientCertificateId: Optional[NonEmptyString] = Optional.Absent,
    stageName: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    cacheClusterEnabled: Optional[Boolean] = Optional.Absent,
    cacheClusterSize: Optional[NonEmptyString] = Optional.Absent,
    cacheClusterStatus: Optional[NonEmptyString] = Optional.Absent,
    methodSettings: Optional[
      Iterable[zio.aws.securityhub.model.AwsApiGatewayMethodSettings]
    ] = Optional.Absent,
    variables: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    documentationVersion: Optional[NonEmptyString] = Optional.Absent,
    accessLogSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings
    ] = Optional.Absent,
    canarySettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings
    ] = Optional.Absent,
    tracingEnabled: Optional[Boolean] = Optional.Absent,
    createdDate: Optional[NonEmptyString] = Optional.Absent,
    lastUpdatedDate: Optional[NonEmptyString] = Optional.Absent,
    webAclArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails = {
    import AwsApiGatewayStageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
      .builder()
      .optionallyWith(
        deploymentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deploymentId)
      .optionallyWith(
        clientCertificateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clientCertificateId)
      .optionallyWith(
        stageName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        cacheClusterEnabled.map(value => value: java.lang.Boolean)
      )(_.cacheClusterEnabled)
      .optionallyWith(
        cacheClusterSize.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cacheClusterSize)
      .optionallyWith(
        cacheClusterStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cacheClusterStatus)
      .optionallyWith(
        methodSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.methodSettings)
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(
        documentationVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.documentationVersion)
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(canarySettings.map(value => value.buildAwsValue()))(
        _.canarySettings
      )
      .optionallyWith(tracingEnabled.map(value => value: java.lang.Boolean))(
        _.tracingEnabled
      )
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        lastUpdatedDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedDate)
      .optionallyWith(
        webAclArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.webAclArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayStageDetails.wrap(buildAwsValue())
}
object AwsApiGatewayStageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayStageDetails =
      zio.aws.securityhub.model.AwsApiGatewayStageDetails(
        deploymentId.map(value => value),
        clientCertificateId.map(value => value),
        stageName.map(value => value),
        description.map(value => value),
        cacheClusterEnabled.map(value => value),
        cacheClusterSize.map(value => value),
        cacheClusterStatus.map(value => value),
        methodSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        variables.map(value => value),
        documentationVersion.map(value => value),
        accessLogSettings.map(value => value.asEditable),
        canarySettings.map(value => value.asEditable),
        tracingEnabled.map(value => value),
        createdDate.map(value => value),
        lastUpdatedDate.map(value => value),
        webAclArn.map(value => value)
      )
    def deploymentId: Optional[NonEmptyString]
    def clientCertificateId: Optional[NonEmptyString]
    def stageName: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def cacheClusterEnabled: Optional[Boolean]
    def cacheClusterSize: Optional[NonEmptyString]
    def cacheClusterStatus: Optional[NonEmptyString]
    def methodSettings: Optional[
      List[zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly]
    ]
    def variables: Optional[Map[NonEmptyString, NonEmptyString]]
    def documentationVersion: Optional[NonEmptyString]
    def accessLogSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ]
    def canarySettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly
    ]
    def tracingEnabled: Optional[Boolean]
    def createdDate: Optional[NonEmptyString]
    def lastUpdatedDate: Optional[NonEmptyString]
    def webAclArn: Optional[NonEmptyString]
    def getDeploymentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getClientCertificateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getStageName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getCacheClusterEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheClusterEnabled", cacheClusterEnabled)
    def getCacheClusterSize: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cacheClusterSize", cacheClusterSize)
    def getCacheClusterStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cacheClusterStatus", cacheClusterStatus)
    def getMethodSettings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("methodSettings", methodSettings)
    def getVariables: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("variables", variables)
    def getDocumentationVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("documentationVersion", documentationVersion)
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getCanarySettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly
    ] = AwsError.unwrapOptionField("canarySettings", canarySettings)
    def getTracingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("tracingEnabled", tracingEnabled)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getWebAclArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("webAclArn", webAclArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly {
    override val deploymentId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clientCertificateId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientCertificateId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val stageName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cacheClusterEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterEnabled())
      .map(value => value: Boolean)
    override val cacheClusterSize: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheClusterSize())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val cacheClusterStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheClusterStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val methodSettings: Optional[
      List[zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.methodSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsApiGatewayMethodSettings.wrap(item)
        }.toList
      )
    override val variables: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val documentationVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentationVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val accessLogSettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessLogSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.wrap(value)
      )
    override val canarySettings: Optional[
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.canarySettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayCanarySettings.wrap(value)
      )
    override val tracingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.tracingEnabled())
      .map(value => value: Boolean)
    override val createdDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastUpdatedDate: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDate())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val webAclArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.webAclArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayStageDetails
  ): zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly = new Wrapper(
    impl
  )
}
