package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AdminAccount(
    accountId: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.securityhub.model.AdminStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AdminAccount = {
    import AdminAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AdminAccount
      .builder()
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AdminAccount.ReadOnly =
    zio.aws.securityhub.model.AdminAccount.wrap(buildAwsValue())
}
object AdminAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AdminAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AdminAccount =
      zio.aws.securityhub.model
        .AdminAccount(accountId.map(value => value), status.map(value => value))
    def accountId: Optional[NonEmptyString]
    def status: Optional[zio.aws.securityhub.model.AdminStatus]
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getStatus: ZIO[Any, AwsError, zio.aws.securityhub.model.AdminStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AdminAccount
  ) extends zio.aws.securityhub.model.AdminAccount.ReadOnly {
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[zio.aws.securityhub.model.AdminStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.securityhub.model.AdminStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AdminAccount
  ): zio.aws.securityhub.model.AdminAccount.ReadOnly = new Wrapper(impl)
}
