package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait ThreatIntelIndicatorType {
  def unwrap: software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType
}
object ThreatIntelIndicatorType {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType
  ): zio.aws.securityhub.model.ThreatIntelIndicatorType = value match {
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.DOMAIN =>
      val r = DOMAIN
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.EMAIL_ADDRESS =>
      val r = EMAIL_ADDRESS
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_MD5 =>
      val r = HASH_MD5
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_SHA1 =>
      val r = HASH_SHA1
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_SHA256 =>
      val r = HASH_SHA256
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_SHA512 =>
      val r = HASH_SHA512
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.IPV4_ADDRESS =>
      val r = IPV4_ADDRESS
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.IPV6_ADDRESS =>
      val r = IPV6_ADDRESS
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.MUTEX =>
      val r = MUTEX
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.PROCESS =>
      val r = PROCESS
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.URL =>
      val r = URL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOMAIN
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.DOMAIN
  }
  case object EMAIL_ADDRESS
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.EMAIL_ADDRESS
  }
  case object HASH_MD5
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_MD5
  }
  case object HASH_SHA1
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_SHA1
  }
  case object HASH_SHA256
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_SHA256
  }
  case object HASH_SHA512
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.HASH_SHA512
  }
  case object IPV4_ADDRESS
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.IPV4_ADDRESS
  }
  case object IPV6_ADDRESS
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.IPV6_ADDRESS
  }
  case object MUTEX extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.MUTEX
  }
  case object PROCESS
      extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.PROCESS
  }
  case object URL extends zio.aws.securityhub.model.ThreatIntelIndicatorType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType.URL
  }
}
