package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait Partition {
  def unwrap: software.amazon.awssdk.services.securityhub.model.Partition
}
object Partition {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.Partition
  ): zio.aws.securityhub.model.Partition = value match {
    case software.amazon.awssdk.services.securityhub.model.Partition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.Partition.AWS =>
      val r = aws
      r
    case software.amazon.awssdk.services.securityhub.model.Partition.AWS_CN =>
      val r = `aws-cn`
      r
    case software.amazon.awssdk.services.securityhub.model.Partition.AWS_US_GOV =>
      val r = `aws-us-gov`
      r
  }
  case object unknownToSdkVersion extends zio.aws.securityhub.model.Partition {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.Partition =
      software.amazon.awssdk.services.securityhub.model.Partition.UNKNOWN_TO_SDK_VERSION
  }
  case object aws extends zio.aws.securityhub.model.Partition {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.Partition =
      software.amazon.awssdk.services.securityhub.model.Partition.AWS
  }
  case object `aws-cn` extends zio.aws.securityhub.model.Partition {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.Partition =
      software.amazon.awssdk.services.securityhub.model.Partition.AWS_CN
  }
  case object `aws-us-gov` extends zio.aws.securityhub.model.Partition {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.Partition =
      software.amazon.awssdk.services.securityhub.model.Partition.AWS_US_GOV
  }
}
