package zio.aws.securityhub.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  Timestamp,
  NonEmptyString,
  AccountId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Invitation(
    accountId: Optional[AccountId] = Optional.Absent,
    invitationId: Optional[NonEmptyString] = Optional.Absent,
    invitedAt: Optional[Timestamp] = Optional.Absent,
    memberStatus: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Invitation = {
    import Invitation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Invitation
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        invitationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.invitationId)
      .optionallyWith(invitedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.invitedAt
      )
      .optionallyWith(
        memberStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.memberStatus)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Invitation.ReadOnly =
    zio.aws.securityhub.model.Invitation.wrap(buildAwsValue())
}
object Invitation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Invitation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Invitation =
      zio.aws.securityhub.model.Invitation(
        accountId.map(value => value),
        invitationId.map(value => value),
        invitedAt.map(value => value),
        memberStatus.map(value => value)
      )
    def accountId: Optional[AccountId]
    def invitationId: Optional[NonEmptyString]
    def invitedAt: Optional[Timestamp]
    def memberStatus: Optional[NonEmptyString]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInvitationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("invitationId", invitationId)
    def getInvitedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getMemberStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("memberStatus", memberStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Invitation
  ) extends zio.aws.securityhub.model.Invitation.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.AccountId(value))
    override val invitationId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.invitationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val invitedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val memberStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Invitation
  ): zio.aws.securityhub.model.Invitation.ReadOnly = new Wrapper(impl)
}
