package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DnsRequestAction(
    domain: Optional[NonEmptyString] = Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent,
    blocked: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DnsRequestAction = {
    import DnsRequestAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DnsRequestAction
      .builder()
      .optionallyWith(
        domain.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(blocked.map(value => value: java.lang.Boolean))(_.blocked)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DnsRequestAction.ReadOnly =
    zio.aws.securityhub.model.DnsRequestAction.wrap(buildAwsValue())
}
object DnsRequestAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DnsRequestAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DnsRequestAction =
      zio.aws.securityhub.model.DnsRequestAction(
        domain.map(value => value),
        protocol.map(value => value),
        blocked.map(value => value)
      )
    def domain: Optional[NonEmptyString]
    def protocol: Optional[NonEmptyString]
    def blocked: Optional[Boolean]
    def getDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domain", domain)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getBlocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blocked", blocked)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DnsRequestAction
  ) extends zio.aws.securityhub.model.DnsRequestAction.ReadOnly {
    override val domain: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val blocked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blocked())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DnsRequestAction
  ): zio.aws.securityhub.model.DnsRequestAction.ReadOnly = new Wrapper(impl)
}
