package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClassificationResult(
    mimeType: Optional[NonEmptyString] = Optional.Absent,
    sizeClassified: Optional[Long] = Optional.Absent,
    additionalOccurrences: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.securityhub.model.ClassificationStatus] =
      Optional.Absent,
    sensitiveData: Optional[
      Iterable[zio.aws.securityhub.model.SensitiveDataResult]
    ] = Optional.Absent,
    customDataIdentifiers: Optional[
      zio.aws.securityhub.model.CustomDataIdentifiersResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ClassificationResult = {
    import ClassificationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ClassificationResult
      .builder()
      .optionallyWith(
        mimeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.mimeType)
      .optionallyWith(sizeClassified.map(value => value: java.lang.Long))(
        _.sizeClassified
      )
      .optionallyWith(
        additionalOccurrences.map(value => value: java.lang.Boolean)
      )(_.additionalOccurrences)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        sensitiveData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sensitiveData)
      .optionallyWith(
        customDataIdentifiers.map(value => value.buildAwsValue())
      )(_.customDataIdentifiers)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ClassificationResult.ReadOnly =
    zio.aws.securityhub.model.ClassificationResult.wrap(buildAwsValue())
}
object ClassificationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ClassificationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ClassificationResult =
      zio.aws.securityhub.model.ClassificationResult(
        mimeType.map(value => value),
        sizeClassified.map(value => value),
        additionalOccurrences.map(value => value),
        status.map(value => value.asEditable),
        sensitiveData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customDataIdentifiers.map(value => value.asEditable)
      )
    def mimeType: Optional[NonEmptyString]
    def sizeClassified: Optional[Long]
    def additionalOccurrences: Optional[Boolean]
    def status
        : Optional[zio.aws.securityhub.model.ClassificationStatus.ReadOnly]
    def sensitiveData
        : Optional[List[zio.aws.securityhub.model.SensitiveDataResult.ReadOnly]]
    def customDataIdentifiers: Optional[
      zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly
    ]
    def getMimeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("mimeType", mimeType)
    def getSizeClassified: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("sizeClassified", sizeClassified)
    def getAdditionalOccurrences: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("additionalOccurrences", additionalOccurrences)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ClassificationStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getSensitiveData: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.SensitiveDataResult.ReadOnly
    ]] = AwsError.unwrapOptionField("sensitiveData", sensitiveData)
    def getCustomDataIdentifiers: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly
    ] =
      AwsError.unwrapOptionField("customDataIdentifiers", customDataIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ClassificationResult
  ) extends zio.aws.securityhub.model.ClassificationResult.ReadOnly {
    override val mimeType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.mimeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sizeClassified: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeClassified())
      .map(value => value: Long)
    override val additionalOccurrences: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalOccurrences())
        .map(value => value: Boolean)
    override val status
        : Optional[zio.aws.securityhub.model.ClassificationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.securityhub.model.ClassificationStatus.wrap(value)
        )
    override val sensitiveData: Optional[
      List[zio.aws.securityhub.model.SensitiveDataResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitiveData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.SensitiveDataResult.wrap(item)
        }.toList
      )
    override val customDataIdentifiers: Optional[
      zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customDataIdentifiers())
      .map(value =>
        zio.aws.securityhub.model.CustomDataIdentifiersResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ClassificationResult
  ): zio.aws.securityhub.model.ClassificationResult.ReadOnly = new Wrapper(impl)
}
