package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchImportFindingsRequest(
    findings: Iterable[zio.aws.securityhub.model.AwsSecurityFinding]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest = {
    import BatchImportFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest
      .builder()
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchImportFindingsRequest.ReadOnly =
    zio.aws.securityhub.model.BatchImportFindingsRequest.wrap(buildAwsValue())
}
object BatchImportFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchImportFindingsRequest =
      zio.aws.securityhub.model.BatchImportFindingsRequest(findings.map {
        item =>
          item.asEditable
      })
    def findings: List[zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly]
    def getFindings: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly
    ]] = ZIO.succeed(findings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest
  ) extends zio.aws.securityhub.model.BatchImportFindingsRequest.ReadOnly {
    override val findings
        : List[zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly] = impl
      .findings()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.AwsSecurityFinding.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest
  ): zio.aws.securityhub.model.BatchImportFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
