package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterResizeInfo(
    allowCancelResize: Optional[Boolean] = Optional.Absent,
    resizeType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterResizeInfo = {
    import AwsRedshiftClusterResizeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterResizeInfo
      .builder()
      .optionallyWith(allowCancelResize.map(value => value: java.lang.Boolean))(
        _.allowCancelResize
      )
      .optionallyWith(
        resizeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resizeType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.wrap(buildAwsValue())
}
object AwsRedshiftClusterResizeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterResizeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo =
      zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo(
        allowCancelResize.map(value => value),
        resizeType.map(value => value)
      )
    def allowCancelResize: Optional[Boolean]
    def resizeType: Optional[NonEmptyString]
    def getAllowCancelResize: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowCancelResize", allowCancelResize)
    def getResizeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resizeType", resizeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterResizeInfo
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly {
    override val allowCancelResize: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowCancelResize())
      .map(value => value: Boolean)
    override val resizeType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resizeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterResizeInfo
  ): zio.aws.securityhub.model.AwsRedshiftClusterResizeInfo.ReadOnly =
    new Wrapper(impl)
}
