package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait AwsIamAccessKeyStatus {
  def unwrap
      : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus
}
object AwsIamAccessKeyStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus
  ): zio.aws.securityhub.model.AwsIamAccessKeyStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus.INACTIVE =>
      val r = Inactive
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.AwsIamAccessKeyStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus =
      software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.securityhub.model.AwsIamAccessKeyStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus =
      software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus.ACTIVE
  }
  case object Inactive extends zio.aws.securityhub.model.AwsIamAccessKeyStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus =
      software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus.INACTIVE
  }
}
