package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamAccessKeyDetails(
    userName: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.securityhub.model.AwsIamAccessKeyStatus] =
      Optional.Absent,
    createdAt: Optional[NonEmptyString] = Optional.Absent,
    principalId: Optional[NonEmptyString] = Optional.Absent,
    principalType: Optional[NonEmptyString] = Optional.Absent,
    principalName: Optional[NonEmptyString] = Optional.Absent,
    accountId: Optional[NonEmptyString] = Optional.Absent,
    accessKeyId: Optional[NonEmptyString] = Optional.Absent,
    sessionContext: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails = {
    import AwsIamAccessKeyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
      .builder()
      .optionallyWith(
        userName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        principalId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        principalType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.principalType)
      .optionallyWith(
        principalName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.principalName)
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        accessKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accessKeyId)
      .optionallyWith(sessionContext.map(value => value.buildAwsValue()))(
        _.sessionContext
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamAccessKeyDetails.wrap(buildAwsValue())
}
object AwsIamAccessKeyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamAccessKeyDetails =
      zio.aws.securityhub.model.AwsIamAccessKeyDetails(
        userName.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        principalId.map(value => value),
        principalType.map(value => value),
        principalName.map(value => value),
        accountId.map(value => value),
        accessKeyId.map(value => value),
        sessionContext.map(value => value.asEditable)
      )
    def userName: Optional[NonEmptyString]
    def status: Optional[zio.aws.securityhub.model.AwsIamAccessKeyStatus]
    def createdAt: Optional[NonEmptyString]
    def principalId: Optional[NonEmptyString]
    def principalType: Optional[NonEmptyString]
    def principalName: Optional[NonEmptyString]
    def accountId: Optional[NonEmptyString]
    def accessKeyId: Optional[NonEmptyString]
    def sessionContext: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly
    ]
    def getUserName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userName", userName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.AwsIamAccessKeyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPrincipalId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getPrincipalType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipalName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalName", principalName)
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAccessKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSessionContext: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly
    ] = AwsError.unwrapOptionField("sessionContext", sessionContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
  ) extends zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly {
    override val userName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status
        : Optional[zio.aws.securityhub.model.AwsIamAccessKeyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.securityhub.model.AwsIamAccessKeyStatus.wrap(value)
        )
    override val createdAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.principalType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.principalName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accessKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accessKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sessionContext: Optional[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionContext())
      .map(value =>
        zio.aws.securityhub.model.AwsIamAccessKeySessionContext.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
  ): zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly = new Wrapper(
    impl
  )
}
